define(['SplashController'], function () {
	'use strict';

	describe("The Splash Controller", function () {
		var controller,
			scope,
			pageServiceMock,
			focusServiceMock,
			authServiceMock;

		beforeEach(function () {
			module('angularTemplateApp');

			focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);
			authServiceMock = jasmine.createSpyObj('authenticationService', ['authenticate']);

			module(function ($provide) {
				$provide.value('focusService', focusServiceMock);
				$provide.value('authenticationService', authServiceMock);
			});

			inject(function ($controller, $rootScope) {
				scope = $rootScope.$new();
				controller = $controller('SplashController', {$scope: scope});
			});
		});

		describe("when the login button is clicked", function () {
			beforeEach(function () {
				scope.beginLogon();
			});

			it("the auth service should be called", function () {
				expect(authServiceMock.authenticate).toHaveBeenCalled();
			});
		});
	});
});